package cx.threeg.dcms.ui.widget;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cx.threeg.dcms.R;
import cx.threeg.dcms.core.HtmlLightParser;
import cx.threeg.dcms.core.Prefs;
import cx.threeg.dcms.ui.ReaderActivity;

public class LinkAdapter extends BaseAdapter {

    private List<HtmlLightParser.LinkItem> data;
    private LayoutInflater inflater;
    private Context ctx;
    private Map<String, Bitmap> cache = new HashMap<String, Bitmap>();

    public LinkAdapter(Context c, List<HtmlLightParser.LinkItem> d) {
        ctx = c;
        data = d;
        inflater = LayoutInflater.from(c);
    }

    public void setData(List<HtmlLightParser.LinkItem> d) {
        data = d;
        notifyDataSetChanged();
    }

    @Override public int getCount() { return data==null?0:data.size(); }
    @Override public Object getItem(int position) { return data.get(position); }
    @Override public long getItemId(int position) { return position; }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        VH h;
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.item_card, parent, false);
            h = new VH();
            h.thumb = (ImageView) convertView.findViewById(R.id.thumb);
            h.title = (TextView) convertView.findViewById(R.id.title);
            h.open = (Button) convertView.findViewById(R.id.btnOpen);
            convertView.setTag(h);
        } else {
            h = (VH) convertView.getTag();
        }
        final HtmlLightParser.LinkItem it = data.get(position);
        h.title.setText(it.title);

        h.open.setOnClickListener(new View.OnClickListener() {
            @Override public void onClick(View v) {
                if (Prefs.isReaderMode(ctx)) {
                    Intent i = new Intent(ctx, ReaderActivity.class);
                    i.putExtra(ReaderActivity.EXTRA_URL, it.href);
                    ctx.startActivity(i);
                } else {
                    Intent i = new Intent(Intent.ACTION_VIEW, android.net.Uri.parse(it.href));
                    ctx.startActivity(i);
                }
            }
        });

        h.thumb.setImageResource(R.drawable.ic_dcms);
        if (it.thumb != null && it.thumb.length()>0) {
            Bitmap b = cache.get(it.thumb);
            if (b != null) {
                h.thumb.setImageBitmap(b);
            } else {
                new ThumbTask(h.thumb, it.thumb).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            }
        }
        return convertView;
    }

    static class VH { ImageView thumb; TextView title; Button open; }

    class ThumbTask extends AsyncTask<Void, Void, Bitmap> {
        private ImageView iv;
        private String url;
        ThumbTask(ImageView v, String u) { iv=v; url=u; }
        @Override protected Bitmap doInBackground(Void... voids) {
            try {
                URL u = new URL(url);
                HttpURLConnection c = (HttpURLConnection) u.openConnection();
                c.setConnectTimeout(8000); c.setReadTimeout(8000);
                InputStream is = c.getInputStream();
                Bitmap b = BitmapFactory.decodeStream(is);
                is.close();
                return b;
            } catch (Exception e) { return null; }
        }
        @Override protected void onPostExecute(Bitmap b) {
            if (b != null) {
                cache.put(url, b);
                iv.setImageBitmap(b);
            }
        }
    }
}
